<?php
include_once __DIR__ . '/config.php';
// If not logged in, redirect to login
if (!isset($_COOKIE[$config['cookie_name']])) {
    header('Location: ./admin/');
    exit;
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>MEDIAMOON LTD Scheduler</title>
    <link rel="stylesheet" href="assets/css/rasty.css">
    <!-- Site favicon -->
    <link rel="icon" type="image/png" href="assets/icons/favicon.png">
</head>
<body class="light">
<!--
    The header is split into two rows for improved readability and
    alignment. The top row contains the scheduler title, theme toggle,
    logout button and live clock, while the bottom row holds the traffic
    statistics bar. Separating the stats into their own row avoids
    alignment problems and keeps the interface tidy on all screen sizes.
-->
<header class="site-header">
    <div class="header-row">
        <!-- Company logo and name -->
        <img src="assets/icons/logo.png" alt="MEDIAMOON LTD logo" class="logo-image">
        <span class="brand">MEDIAMOON LTD — Logged in as admin</span>
        <button id="themeToggle" class="header-button">🌙</button>
        <button id="logoutBtn" class="header-button">Logout</button>
        <span id="serverTime" class="server-time">🕒 --:--:--</span>
    </div>
    <div id="topStats" class="stats-bar">
        <div class="stat-card">
            <span class="label">Impressions</span>
            <span id="statImpressions" class="value">--</span>
        </div>
        <div class="stat-card">
            <span class="label">Spent Today</span>
            <span id="statSpent" class="value">$0.00</span>
        </div>
        <div class="stat-card">
            <span class="label">Traffic Purchased</span>
            <span id="statTraffic" class="value">--</span>
        </div>
    </div>
</header>


<main>
    <!-- Campaign ID list with run/pause times -->
    <section id="campaigns">
        <h2>Campaign IDs</h2>
        <div id="campaignList">
            <!-- Dynamic rows go here -->
        </div>
        <button id="addCampaign" class="button">Add</button>
    </section>

    <!-- API Token entry -->
    <section id="apiToken">
        <h2>API Token</h2>
        <input id="apiTokenInput" type="password" placeholder="Enter your Bearer token" class="regular-text">
        <!-- API status indicator: a coloured dot and status text updated via JS -->
        <div class="api-status">
            <span id="apiStatusDot" class="api-dot api-inactive"></span>
            <span id="apiStatusText" class="api-status-text">API Inactive</span>
        </div>
        <div class="row" style="margin-top:10px;">
            <button id="startScheduler" class="button">Start</button>
            <button id="stopScheduler" class="button" style="margin-left:10px;">Stop</button>
        </div>
    </section>

    <!-- Notification settings -->
    <section id="notifications">
        <h2>Notifications</h2>
        <div class="row">
            <label>Email</label>
            <input id="notifyEmail" type="email" placeholder="youremail@example.com" style="width:200px">
            <label>Telegram Token</label>
            <input id="telegramToken" type="text" placeholder="Bot token" style="width:200px">
            <label>Telegram Chat ID</label>
            <input id="telegramChat" type="text" placeholder="Chat ID" style="width:100px">
        </div>
        <!-- Notification channel toggles -->
        <div class="row" style="margin-top:10px;">
            <label><input id="enableEmail" type="checkbox"> Enable email notifications</label>
            <label style="margin-left:20px;"><input id="enableTelegram" type="checkbox"> Enable Telegram notifications</label>
            <label style="margin-left:20px;"><input id="enablePush" type="checkbox"> Enable push notifications</label>
        </div>
        <div class="row" style="margin-top:10px;">
            <strong style="font-weight:bold;">Notify me about:</strong>
        </div>
        <div class="row" style="margin-top:5px;">
            <label><input id="notifyRejected" type="checkbox"> Rejection (status 3)</label>
            <label style="margin-left:20px;"><input id="notifyApproved" type="checkbox"> Approval (status 4)</label>
            <label style="margin-left:20px;"><input id="notifyCompleted" type="checkbox"> Completed (status 9)</label>
            <label style="margin-left:20px;"><input id="notifySchedulerStopped" type="checkbox"> Scheduler stopped</label>
        </div>
        <p style="font-size:12px; color:#777;">Push notifications will only work if the browser supports them and permission is granted. Telegram requires a bot token and chat ID. Leave a channel unchecked to disable notifications for that channel. Use the event checkboxes above to choose which events trigger notifications.</p>
    </section>

    <!-- Log output -->
    <section id="logSection">
        <h2>Log</h2>
        <pre id="log" class="log"></pre>
        <button id="clearLog" class="button" style="margin-top:10px;">Clear Logs</button>
        <button id="downloadLogs" class="button" style="margin-top:10px; margin-left:10px;">Download Logs</button>
        <button id="resetCampaigns" class="button" style="margin-top:10px; margin-left:10px;">Reset Campaigns</button>
    </section>
</main>
<!-- Progress bar removed -->
<footer>
    Powered by RASTY Automation © 2025
</footer>

<!-- Scripts -->
<script src="assets/js/main.js"></script>
</body>
</html>