<?php
include_once __DIR__ . '/../config.php';

// If user is already logged in (cookie set), redirect to main scheduler
if (isset($_COOKIE[$config['cookie_name']])) {
    header('Location: ../scheduler.php');
    exit;
}

$error = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $username = $_POST['username'] ?? '';
    $password = $_POST['password'] ?? '';
    if ($username === $config['username'] && $password === $config['password']) {
        setcookie($config['cookie_name'], 'active', $config['cookie_lifetime'], '/');
        header('Location: ../scheduler.php');
        exit;
    } else {
        $error = 'Invalid username or password';
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>MEDIAMOON LTD Login</title>
    <link rel="stylesheet" href="../assets/css/rasty.css">
    <!-- Favicon for browser tab -->
    <link rel="icon" type="image/png" href="../assets/icons/favicon.png">
</head>
<body class="login-body">
<div class="login-card">
    <img src="../assets/icons/logo.png" alt="MEDIAMOON LTD logo" class="logo-image" style="width:40px; height:auto; margin-bottom:10px;">
    <h1>MEDIAMOON LTD</h1>
    <form method="post">
        <label>Username</label>
        <input type="text" name="username" value="admin" required>
        <label>Password</label>
        <input type="password" name="password" required>
        <div class="remember">
            <input type="checkbox" name="remember" checked> Remember me
        </div>
        <button type="submit">Login</button>
        <?php if ($error): ?>
            <p class="error">
                <?php echo htmlspecialchars($error, ENT_QUOTES, 'UTF-8'); ?>
            </p>
        <?php endif; ?>
    </form>
</div>
</body>
</html>